/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.ClassIdClient;
import com.ibm.hwmca.fw.managed.ClassIdTasklet;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.HashMap;

public class ClassId
implements Serializable,
Persistable,
Comparable {
    private String packageName;
    private String className;
    private String string;
    private static HashMap classMap;
    private static Object classMapMonitor;
    private static final String TRACE_MASKT = "XFRMCIDT";
    private static final String TRACE_MASKF = "XFRMCIDF";
    private static final String TRACE_MASKD = "XFRMCIDD";
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 8123320947911337152L;

    public ClassId() {
        this.setPackageName(null);
        this.setClassName(null);
        this.string = null;
    }

    public ClassId(String packageName, String className) {
        if (packageName.endsWith(".")) {
            this.setPackageName(packageName.substring(0, packageName.length()));
        } else {
            this.setPackageName(packageName);
        }
        this.setClassName(className);
        this.string = null;
    }

    public ClassId(Object object) {
        this(object.getClass());
    }

    public ClassId(Class objectClass) {
        String packageName = objectClass.getPackage().getName();
        String className = objectClass.getName();
        if (packageName != null && packageName.length() != 0) {
            className = className.substring(packageName.length() + 1);
        }
        this.setPackageName(packageName);
        this.setClassName(className);
        this.string = null;
    }

    public ClassId(String id) {
        String packageName = null;
        String className = null;
        this.string = null;
        int separatorIx = id.lastIndexOf(46) + 1;
        if (separatorIx == 0) {
            throw new IllegalArgumentException("Cannot find the package name in class id \"" + id + "\"");
        }
        packageName = id.substring(0, separatorIx - 1);
        className = id.substring(separatorIx);
        this.setPackageName(packageName);
        this.setClassName(className);
    }

    public ClassId(PersistentData data) {
        this(((Persistent)data).persistentForm);
    }

    public String getPackageName() {
        return this.packageName;
    }

    protected void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getClassName() {
        return this.className;
    }

    protected void setClassName(String className) {
        this.className = className;
    }

    public String getFullClassName() {
        if (this.string == null) {
            StringBuffer buff = new StringBuffer();
            String packageName = this.getPackageName();
            String className = this.getClassName();
            if (packageName != null) {
                buff.append(packageName).append(".");
            }
            if (className != null) {
                buff.append(className);
            }
            this.string = buff.toString();
        }
        return this.string;
    }

    public boolean isInstanceOf(Class baseClass) throws IllegalStateException {
        if (!CommonSystem.getCommonSystem().isLocationUnified() && CommonSystem.getCommonSystem().isLocationClient()) {
            throw new IllegalStateException("isInstanceOf(Class) cannot be called in a client context.");
        }
        boolean result = false;
        try {
            Class<?> myClass = Class.forName(this.getFullClassName());
            result = baseClass.isAssignableFrom(myClass);
        }
        catch (ClassNotFoundException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstanceOf(String baseClassName) throws HException {
        boolean result = false;
        String[] implementedClasses = null;
        Object object = classMapMonitor;
        synchronized (object) {
            if (classMap == null) {
                classMap = new HashMap();
            }
            if ((implementedClasses = (String[])classMap.get(this.getFullClassName())) == null) {
                implementedClasses = !CommonSystem.getCommonSystem().isLocationUnified() && CommonSystem.getCommonSystem().isLocationClient() ? new ClassIdClient().getImplementedClasses(this) : ClassIdTasklet.getImplementedClasses(this);
                for (int ix = 0; ix < implementedClasses.length; ++ix) {
                    implementedClasses[ix] = implementedClasses[ix].intern();
                }
                classMap.put(this.getFullClassName(), implementedClasses);
            }
        }
        baseClassName = baseClassName.intern();
        for (int ix = 0; ix < implementedClasses.length && !result; ++ix) {
            result = baseClassName == implementedClasses[ix];
        }
        return result;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.persistentForm = this.toString();
        return result;
    }

    public boolean isUpgradeData() {
        return false;
    }

    public String toString() {
        return this.getFullClassName();
    }

    public boolean equals(Object test) {
        boolean result = false;
        if (test instanceof ClassId) {
            result = this.getPackageName() == null && ((ClassId)test).getPackageName() == null || this.getPackageName() != null && this.getPackageName().equals(((ClassId)test).getPackageName());
            result &= this.getClassName() == null && ((ClassId)test).getClassName() == null || this.getClassName() != null && this.getClassName().equals(((ClassId)test).getClassName());
        }
        return result;
    }

    public int hashCode() {
        int result = 0;
        if (this.getPackageName() != null) {
            result += this.getPackageName().hashCode();
        }
        if (this.getClassName() != null) {
            result += this.getClassName().hashCode();
        }
        return result;
    }

    public int compareTo(Object id) {
        return this.toString().compareTo(((ClassId)id).toString());
    }

    static {
        classMapMonitor = new Object();
    }

    class Persistent
    implements PersistentData {
        String persistentForm;
        private static final long serialVersionUID = -2086897937836473201L;

        Persistent() {
        }
    }
}

